// 处理资源URL的工具函数
export function getAssetUrl(url) {
  if (!url) return ''
  
  // 如果是完整的URL（以http或https开头），直接返回
  if (url.startsWith('http://') || url.startsWith('https://')) {
    return url
  }
  
  // 如果是以/src/开头的路径，移除/article前缀
  if (url.startsWith('/article/src/')) {
    return url.replace('/article', '')
  }
  
  // 如果是以src/开头的路径，直接返回
  if (url.startsWith('src/')) {
    return '/' + url
  }
  
  return url
}
